#include "object.h"

#include <boost/units/detail/utility.hpp>

namespace maps::wiki::masstransit {

const Objects&
ObjectMapBase::operator()() const
{
    return objects_;
}

Objects&
ObjectMapBase::operator()()
{
    return objects_;
}

bool
ObjectMapBase::empty() const
{
    return index_.empty();
}

size_t
ObjectMapBase::count(DBID id) const
{
    return index_.count(id);
}

void
ObjectMapBase::insert(DBID id, const ObjectPtr& object)
{
    REQUIRE(
        !index_.count(id),
        "Unable to add object " <<
        boost::units::simplify_typename(*object) <<
        ", id=" << id <<
        " There is object " <<
        boost::units::simplify_typename(*objects_[index_[id]])
        << " with same id");
    index_[id] = objects_.size();
    objects_.push_back(object);
}

ObjectPtr
ObjectMapBase::at(DBID id) const
{
    const auto it = index_.find(id);
    REQUIRE(it != index_.end(), "Referencing unknown id=" << id);
    return objects_[it->second];
}

} // namespace maps::wiki::masstransit
