#pragma once

#include "id_map.h"

#include <map>
#include <memory>

namespace maps::wiki::masstransit {

struct Object {
    Object() = default;
    Object(const Object&) = delete;
    Object(Object&&) = default;
    virtual ~Object() = default;
};

using ObjectPtr = std::shared_ptr<Object>;
using Objects = std::vector<ObjectPtr>;

class ObjectMapBase {
public:
    ObjectMapBase() = default;
    ObjectMapBase(const ObjectMapBase&) = delete;
    virtual ~ObjectMapBase() = default;

public:
    const Objects& operator()() const;
    Objects& operator()();

    bool empty() const;
    size_t count(DBID id) const;

    void insert(DBID id, const ObjectPtr& object);

protected:
    ObjectPtr at(DBID id) const;

private:
    Objects objects_;
    std::map<DBID, size_t> index_;
};

template<typename T>
class ObjectMap : public ObjectMapBase {
public:
    ObjectMap() = default;
    ObjectMap(const ObjectMap&) = delete;
    virtual ~ObjectMap() = default;

    const T& operator[](DBID id) const { return dynamic_cast<const T&>(*at(id)); }
    T& operator[](DBID id) { return dynamic_cast<T&>(*at(id)); }
};

} // namespace maps::wiki::masstransit
