#include "object_handler.h"

#include "masstransit.h"

namespace maps::wiki::masstransit {

ObjectHandler::ObjectHandler(
        Masstransit& masstransit,
        ObjectMapBase& objectMap)
    : masstransit_(masstransit)
    , objectMap_(objectMap)
{ }

const Objects&
ObjectHandler::objects() const
{
    return objectMap_();
}

Objects&
ObjectHandler::objects()
{
    return objectMap_();
}

void
ObjectHandler::insert(DBID id, const ObjectPtr& object)
{
    objectMap_.insert(id, object);
}

IdMap&
ObjectHandler::idMap()
{
    return masstransit_.idMap;
}

DataErrorMessage
ObjectHandler::DATA_ERROR()
{
    return DataErrorMessage(masstransit_.log());
}

} // namespace maps::wiki::masstransit
