#pragma once

#include "common.h"
#include "log.h"
#include "object.h"
#include "object_helpers.h"
#include "params.h"

namespace maps::wiki::masstransit {

class Masstransit;

class ObjectHandler {
public:
    ObjectHandler(Masstransit& masstransit, ObjectMapBase& objectMap);
    ObjectHandler(const ObjectHandler&) = delete;
    virtual ~ObjectHandler() = default;

    const Objects& objects() const;
    Objects& objects();

    void insert(DBID id, const ObjectPtr& object);

protected:
    IdMap& idMap();
    DataErrorMessage DATA_ERROR();

    Masstransit& masstransit_;
    ObjectMapBase& objectMap_;
};

} // namespace maps::wiki::masstransit
