#pragma once

#include "common.h"
#include "magic_strings.h"
#include "object.h"

#include <maps/libs/locale/include/language.h>

#include <pqxx/pqxx>

namespace maps::wiki::masstransit {

std::string toString(const std::vector<DBID>& ids);
std::string toString(const std::vector<FtType>& ids);

class PqxxNullValueError : public RuntimeError {
public:
    PqxxNullValueError() { }
    explicit PqxxNullValueError(const std::string& what): RuntimeError(what) { }
};

template<typename T>
T getAttr(const pqxx::row& tuple, const std::string& attrName)
{
    return to<T>(getAttr<std::string>(tuple, attrName));
}

template<>
bool getAttr(const pqxx::row& tuple, const std::string& attrName);

template<>
std::string getAttr(const pqxx::row& tuple, const std::string& attrName);

template<>
Point getAttr(const pqxx::row& tuple, const std::string& attrName);

template<>
FtType getAttr(const pqxx::row& tuple, const std::string& attrName);

template<>
Ids getAttr(const pqxx::row& tuple, const std::string& attrName);

template<typename T>
T getAttr(const pqxx::row& tuple, const std::string& attrName, const T& defaultValue)
{
    try {
        return getAttr<T>(tuple, attrName);
    } catch (const PqxxNullValueError&) {
        return defaultValue;
    }
}

} // namespace maps::wiki::masstransit
