#include "time_zone.h"
#include <yandex/maps/wiki/masstransit/geobase.h>

#include <geobase/include/lookup.hpp>

namespace gb = NGeobase::NImpl;

namespace maps::wiki::masstransit {

std::string
timeZoneName(const Point& point)
{
    static const ::gb::TLookup GEOBASE_LOOKUP{getGeodataBinPath()};

    return GEOBASE_LOOKUP.GetTimezoneByLocation(point.y(), point.x()).Name;
}

} // namespace maps::wiki::masstransit
