#pragma once

#include "db_helper.h"
#include "object.h"
#include "object_handler.h"

#include <maps/libs/pgpool/include/pgpool3.h>

namespace maps::wiki::masstransit {

class YmapsdfObjectHandler : public ObjectHandler {
public:
    YmapsdfObjectHandler(Masstransit& masstransit, ObjectMapBase& objectMap);

    virtual std::string name() const = 0;

    void read(DBHelper& dBHelper);
    virtual void update();

private:
    virtual std::vector<FtType> ftTypes() const { return {}; }

    virtual bool allowFtTypeId() const { return true; }
    virtual bool allowParentId() const { return true; }
    virtual bool allowPointGeom() const { return false; }
    virtual bool allowNm() const { return true; }

    virtual StringVector attrs() const { return {}; }
    virtual StringVector rolesToMasters() const { return {}; }
    virtual StringVector rolesToSlaves() const { return {}; }
    virtual std::string extraSelectColumns() const { return {}; }

    virtual std::string loadIdsSql() const;
    virtual std::string loadRowsSqlTemplate() const;

    virtual void addObject(const pqxx::row& tuple) = 0;
    virtual void updateObject(Object& /*object*/) { }
};

} // namespace maps::wiki::masstransit
