#pragma once

#include <yandex/maps/wiki/mds_dataset/types.h>
#include <maps/libs/common/include/pimpl_utils.h>
#include <yandex/maps/mds/mds.h>

#include <memory>

namespace maps {
namespace wiki {
namespace mds_dataset {

/// @brief Holds information about a dataset file in the MDS storage
class FileLink
{
public:
    FileLink(mds::Key mdsKey, std::string name, std::string readingUrl);

    const mds::Key& mdsKey() const;
    const std::string& name() const;
    const std::string& readingUrl() const;

    bool operator<(const FileLink& other) const;
    bool operator==(const FileLink& other) const;

private:
    COPYABLE_PIMPL_DECLARATIONS(FileLink)
};

typedef std::vector<FileLink> FileLinks;

template <typename MetaData>
class DatasetReader;

/**
 * @brief Holds information of the dataset MDS files and metadata.
 * MetaData defines the type of metadata held along with the dataset
 * (e.g. ExportMetadata)
 */
template <typename MetaData>
class Dataset
{
public:
    ~Dataset();
    Dataset(Dataset&&);
    Dataset(MetaData metadata, FileLinks fileLinks);

    Dataset& operator=(Dataset&&);
    Dataset(const Dataset& other);
    Dataset& operator=(const Dataset& other);

    // @return metadata of the dataset
    const MetaData& metadata() const;

    // @return links to dataset files stored in MDS
    const FileLinks& fileLinks() const;

    // shortcut to dataset id
    const DatasetID id() const { return metadata().id(); }

    // shortcut to dataset region
    const Region region() const { return metadata().region(); }

    bool operator<(const Dataset<MetaData>& other) const;
    bool operator==(const Dataset<MetaData>& other) const;

private:
    class Impl;
    std::unique_ptr<Impl> pimpl_;
};

std::ostream& operator<<(std::ostream& out, const FileLink& fileLink);

template <typename MetaData>
std::ostream& operator<<(std::ostream& out, const Dataset<MetaData>& dataset);

} // mds_dataset
} // wiki
} // maps
