#pragma once

#include <maps/libs/common/include/exception.h>
#include <yandex/maps/wiki/mds_dataset/types.h>

namespace maps {
namespace wiki {
namespace mds_dataset {

/// @brief General MDS dataset error
class MdsDatasetError : public Exception {};

/// @brief Attempt to create a dataset with invalid metadata
class InvalidMetadata : public MdsDatasetError {};

/// @brief Attempt to create a dataset with one of the files being invalid
class InvalidDatasetFile : public MdsDatasetError {};

/// @brief Attempt to create a dataset with id that already exists
class DuplicateDataset : public MdsDatasetError
{
public:
    DuplicateDataset(DatasetID id_, Region region_)
        : id(std::move(id_))
        , region(std::move(region_))
    {
    }

    const DatasetID id;
    const Region region;
};

/// @brief Dataset with given id was not found
class DatasetNotFound : public MdsDatasetError
{
public:
    DatasetNotFound(DatasetID id_, Region region_)
        : id(std::move(id_))
        , region(std::move(region_))
    {
    }

    const DatasetID id;
    const Region region;
};

} // mds_dataset
} // wiki
} // maps
