#pragma once

#include <yandex/maps/wiki/mds_dataset/filter.h>
#include <yandex/maps/wiki/mds_dataset/metadata.h>
#include <yandex/maps/wiki/mds_dataset/types.h>
#include <maps/libs/common/include/pimpl_utils.h>

#include <memory>

namespace maps {
namespace wiki {
namespace mds_dataset {

/// @brief Metadata of export dataset
class ExportMetadata
{
public:
    ExportMetadata(BasicMetadata basicMetadata, Subset subset, IsTested tested);

    typedef ExportFilter FilterType;

    /// @return basic metadata
    const BasicMetadata& basic() const;

    /// @return subset of export dataset
    Subset subset() const;

    /// @return whether export dataset is tested
    IsTested tested() const;

    /// @return dataset ID
    const DatasetID& id() const;

    /// @return dataset region
    const Region& region() const;

    bool operator<(const ExportMetadata& other) const;
    bool operator==(const ExportMetadata& other) const;

    COPYABLE_PIMPL_DECLARATIONS(ExportMetadata)
};

template <>
void validateMetadata(const ExportMetadata& metadata);

std::ostream& operator<<(std::ostream& out, IsTested tested);
std::ostream& operator<<(std::ostream& out, const ExportMetadata& metadata);

} // mds_dataset
} // wiki
} // maps
