#pragma once

#include <yandex/maps/wiki/mds_dataset/types.h>
#include <maps/libs/common/include/pimpl_utils.h>

#include <chrono>
#include <iosfwd>
#include <memory>

namespace maps {
namespace wiki {
namespace mds_dataset {

/// @brief Metadata common for all dataset types
class BasicMetadata
{
public:
    BasicMetadata(
        DatasetID id_,
        DatasetStatus status_,
        Timestamp created_ = std::chrono::system_clock::now());

    BasicMetadata(
        DatasetID id_,
        Region region_,
        DatasetStatus status_,
        Timestamp created_ = std::chrono::system_clock::now());

    const DatasetID& id() const;
    const Region& region() const;
    DatasetStatus status() const;
    Timestamp created() const;

    bool operator<(const BasicMetadata& other) const;
    bool operator==(const BasicMetadata& other) const;

    COPYABLE_PIMPL_DECLARATIONS(BasicMetadata)
};

template <typename MetaData>
void validateMetadata(const MetaData& metadata);

std::ostream& operator<<(std::ostream& out, const BasicMetadata& metadata);

} // mds_dataset
} // wiki
} // maps
