#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <chrono>
#include <string>
#include <vector>

namespace maps {
namespace wiki {
namespace mds_dataset {

typedef std::string DatasetID;
typedef std::chrono::system_clock::time_point Timestamp;
typedef std::string Region;
typedef std::vector<Region> Regions;
const Region NO_REGION = {};

enum class DatasetStatus
{
    // The dataset was successfully generated, data files are available
    Available = 0,

    // There were errors generating the dataset, diagnostic info is available
    Incomplete = 1,

    // The dataset files are being deleted
    Deleting = 2,

    // The dataset files have been deleted
    Deleted = 3,

    Max = Deleted
};

DECLARE_ENUM_IO(DatasetStatus);

enum class Subset
{
    Ymapsdf = 0,
    Service = 1,
    Masstransit = 2,
    Poi = 3,
    Mrc = 4,
    MrcPedestrian = 5,
    Max = MrcPedestrian
};

DECLARE_ENUM_IO(Subset);

enum class IsTested
{
    No = 0,
    Yes = 1
};

inline int64_t timestampToSec(Timestamp ts)
{
    return Timestamp::clock::to_time_t(ts);
}

} // mds_dataset
} // wiki
} // maps
