#include <yandex/maps/wiki/mds_dataset/metadata.h>

#include <ostream>
#include <utility>

namespace maps {
namespace wiki {
namespace mds_dataset {

class BasicMetadata::Impl
{
public:
    Impl(DatasetID id, Region region, DatasetStatus status, Timestamp created)
            : id_(std::move(id))
            , region_(std::move(region))
            , status_(status)
            , created_(created)
    {}

    DatasetID id_;
    Region region_;
    DatasetStatus status_;
    Timestamp created_;

    auto tie() const -> decltype(std::tie(id_, region_, status_, created_))
    {
        return std::tie(id_, region_, status_, created_);
    }
};

BasicMetadata::BasicMetadata(
    DatasetID id,
    Region region,
    DatasetStatus status,
    Timestamp created)
        : impl_(new Impl(std::move(id), std::move(region), status, created))
{}

BasicMetadata::BasicMetadata(
    DatasetID id,
    DatasetStatus status,
    Timestamp created)
        : impl_(new Impl(std::move(id), NO_REGION, status, created))
{}

COPYABLE_PIMPL_DEFINITIONS(BasicMetadata)

const DatasetID& BasicMetadata::id() const
{
    return impl_->id_;
}

const Region& BasicMetadata::region() const
{
    return impl_->region_;
}

DatasetStatus BasicMetadata::status() const
{
    return impl_->status_;
}

Timestamp BasicMetadata::created() const
{
    return impl_->created_;
}

bool BasicMetadata::operator<(const BasicMetadata& other) const
{
    return impl_->tie() < other.impl_->tie();
}

bool BasicMetadata::operator==(const BasicMetadata& other) const
{
    return impl_->tie() == other.impl_->tie();
}

std::ostream& operator<<(std::ostream& out, const BasicMetadata& metadata)
{
    return out << "{ id: " << metadata.id()
               << ", region: '" << metadata.region() << "'"
               << ", status: " << metadata.status()
               << ", created: " << timestampToSec(metadata.created())
               << " }";
}

} // mds_dataset
} // wiki
} // maps


