#pragma once

#include "include/yandex/maps/wiki/mds_dataset/dataset.h"

#include <pqxx/pqxx>
#include <string>
#include <unordered_map>
#include <vector>

namespace maps {
namespace wiki {
namespace mds_dataset {

namespace sql {

template <typename MetaData>
struct Traits
{
    static const std::string TABLE_META;
    static const std::string TABLE_FILES;
    static const std::string META_COLUMNS;
};

template <typename MetaData>
void writeMetadata(
        const MetaData& metadata,
        pqxx::transaction_base& txn);

template <typename MetaData>
void setDatasetStatus(
        const DatasetID& id,
        const Region& region,
        DatasetStatus status,
        pqxx::transaction_base& txn);

template <typename MetaData>
void writeFileLink(
        const DatasetID& id,
        const Region& region,
        const FileLink& fileLink,
        pqxx::transaction_base& txn);

template <typename MetaData>
void writeFileLinks(
        const DatasetID& id,
        const Region& region,
        const FileLinks& fileLinks,
        pqxx::transaction_base& txn);

template <typename MetaData>
FileLinks loadFileLinks(
        const DatasetID& id,
        const Region& region,
        pqxx::transaction_base& txn);

template <typename MetaData>
std::vector<Dataset<MetaData>> loadDatasets(
        pqxx::transaction_base& txn,
        const std::string& filterClause = "",
        const std::string& limitClause = "");

template <typename MetaData>
void deleteFileLinks(
        const DatasetID& id,
        const Region& region,
        pqxx::transaction_base& txn);

} // sql
} // mds_dataset
} // wiki
} // maps
