#include <yandex/maps/wiki/mds_dataset/types.h>

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps {
namespace wiki {
namespace mds_dataset {

namespace {

const enum_io::Representations<DatasetStatus> DATASET_STATUS_NAMES{
    {DatasetStatus::Available, "available"},
    {DatasetStatus::Incomplete, "incomplete"},
    {DatasetStatus::Deleting, "deleting"},
    {DatasetStatus::Deleted, "deleted"}
};

const enum_io::Representations<Subset> SUBSET_NAMES{
    {Subset::Ymapsdf, "ymapsdf"},
    {Subset::Ymapsdf, "domain"},
    {Subset::Service, "service"},
    {Subset::Masstransit, "masstransit"},
    {Subset::Poi, "poi"},
    {Subset::Mrc, "mrc"},
    {Subset::MrcPedestrian, "mrc-pedestrian"},
};

} // anonymous namespace

DEFINE_ENUM_IO(DatasetStatus, DATASET_STATUS_NAMES);
DEFINE_ENUM_IO(Subset, SUBSET_NAMES);

} // mds_dataset
} // wiki
} // maps
