#pragma once

#include <maps/libs/geolib/include/point.h>
#include <yandex/maps/wiki/revision/common.h>
#include <pqxx/pqxx>

#include <optional>
#include <string>

namespace maps::wiki::misc {

struct PointToBldResult
{
    geolib3::Point2 point; // point on the edge of building
    double distance;
    double azimuth; // outbuilding direction; North - 0, East - 90, ...
    bool isInsideBld;
    revision::DBID bldId;
};

std::optional<PointToBldResult> pullPointTowardsBld(
    pqxx::transaction_base& txn, // you should exec 'SET search_path=vrevisions_(trunk|stable|...),public'
                                 // at this transaction according to branchId
    revision::DBID branchId,
    const geolib3::Point2& mercPoint,
    bool findInsideBld,
    double searchRadius,
    const std::string& bldNumber);

} // namespace maps::wiki::misc
