#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/json/include/value.h>
#include <maps/wikimap/mapspro/libs/sqs_client/include/configuration.h>

#include <aws/sqs/SQSClient.h>
#include <string>

namespace maps::wiki::notifications {

enum class MailType
{
    NewsSubscriptionThanks,
    AchievementEditsCount
};

DECLARE_ENUM_IO(MailType);


struct MailEvent
{
    MailEvent(
        uint64_t puid,
        MailType type,
        json::Value args = json::Value{json::repr::ObjectRepr{}});

    uint64_t puid;
    MailType type;
    json::Value args;
};


class MailEventSender
{
public:
    MailEventSender(
        std::string sqsQueueName,
        const sqs::Configuration& sqsConfig,
        const Aws::SQS::SQSClient& sqsClient);

    bool send(const MailEvent& event) const;

private:
    std::string sqsQueueName_;
    const sqs::Configuration& sqsConfig_;
    const Aws::SQS::SQSClient& sqsClient_;
};

} // namespace maps::wiki::notifications
