#pragma once

#include <maps/libs/introspection/include/comparison.h>
#include <yandex/maps/wiki/diffalert/revision/aoi_diff_loader.h>

#include <functional>
#include <map>
#include <string>

namespace maps {
namespace wiki {
namespace outsource {

constexpr int MAX_FC_SET = 1023;

const std::string OUTSOURCE_CONFIG_RESOURCE_ID = "/outsource-config";

/**
 * Store attrs on the start of the work
 */
class FixedTaskAttributes
{
public:
    std::string taskType;
    int fcSet;
    std::string companyId;

    explicit FixedTaskAttributes(const revision::ObjectRevision& rev);
};

inline auto introspect(const FixedTaskAttributes& attrs)
    -> decltype(std::tie(attrs.taskType, attrs.fcSet, attrs.companyId))
{
    return std::tie(attrs.taskType, attrs.fcSet, attrs.companyId);
}

/**
 * Store attrs on the end of the work
 */
class VaryingTaskAttributes
{
public:
    double complexityRate;
    std::string outsourcerLogin;
    std::string quality;

    explicit VaryingTaskAttributes(const revision::ObjectRevision& rev);
};

inline auto introspect(const VaryingTaskAttributes& attrs)
    -> decltype(std::tie(attrs.complexityRate, attrs.outsourcerLogin))
{
    return std::tie(attrs.complexityRate, attrs.outsourcerLogin);
}

using introspection::operator==;
using introspection::operator!=;

using CalcDiff = std::function<double(
    const FixedTaskAttributes& taskAttrs,
    const diffalert::AoiDiffLoader& loader)>;

class Config
{
public:
    explicit Config(const std::string& content);

    struct CompanyInfo
    {
        std::string id;
        std::string name;
        std::string managerLogin;
        bool taxIncluded;
        double taxRate;
        std::string rateId;
    };

    struct TaskTypeInfo
    {
        std::string id;
        CalcDiff calcWork;
        CalcDiff calcCorrections;
        double rate;
        std::string labelRu;
    };

    CompanyInfo companyInfo(const std::string& id) const;

    const TaskTypeInfo& taskTypeInfo(const std::string& id, const std::string& companyId) const;

private:
    std::unordered_map<std::string, std::unordered_map<std::string, TaskTypeInfo>> rateIdTaskTypesById_;
    std::unordered_map<std::string, CompanyInfo> companiesById_;
};

} // namespace outsource
} // namespace wiki
} // namespace maps
