#pragma once

#include "config.h"

#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/diffalert/revision/editor_config.h>
#include <yandex/maps/wiki/revision/common.h>

#include <boost/optional.hpp>

namespace maps {
namespace wiki {
namespace outsource {

enum class RegionCalcPolicy {
    AllTasks,
    CurrentTask
};

struct TaskResult
{
    explicit TaskResult(revision::DBID regionId)
        : regionId(regionId)
        , rate(0.0)
        , workAmount(0.0)
        , moneyAmount(0.0)
        , fcSet(0)
        , correctionAmount(0.0)
        , correctionPercentage(0.0)
    {}

    revision::DBID regionId;
    std::string regionName;

    std::string companyName;
    bool taxIncluded;
    std::string outsourcerLogin;
    std::string quality;
    double rate;
    double complexityRate;
    double taxRate;
    double workAmount;
    double moneyAmount;
    std::string taskType;
    std::string taskTypeLabel;
    int fcSet;
    std::string workStart;
    std::string workEnd;
    double correctionAmount;
    double correctionPercentage;
    boost::optional<std::string> correctionStart;
    boost::optional<std::string> correctionEnd;

    std::string errorDescription;
};

using TaskResults = std::unordered_map<revision::DBID, std::vector<TaskResult>>;

// Empty regionIds param means load all regions in awaiting_billing status from DB.
TaskResults calcTaskResults(
        const revision::DBIDSet& regionIds,
        RegionCalcPolicy calcPolicy,
        revision::DBID branchId,
        pgpool3::Pool& pgPool,
        const diffalert::EditorConfig& editorConfig,
        const outsource::Config& outsourceConfig);

} // namespace outsource
} // namespace wiki
} // namespace maps
