#pragma once

#include <maps/libs/json/include/value.h>
#include <maps/libs/geolib/include/point.h>

#include <pqxx/pqxx>
#include <cstdint>
#include <optional>
#include <string>
#include <vector>

namespace maps::wiki::pedestrian {

class Region
{
public:
    Region(uint64_t objectRegionId, const json::Value& pointsJson, uint64_t modifiedBy);

    uint64_t objectRegionId() const {return objectRegionId_;}
    const std::vector<geolib3::Point2>& mercPoints() const {return mercPoints_;}
    uint64_t modifiedBy() const {return modifiedBy_;}

private:
    uint64_t objectRegionId_;
    std::vector<geolib3::Point2> mercPoints_;
    uint64_t modifiedBy_;
};

std::optional<Region> regionById(pqxx::transaction_base& coreTxn, uint64_t objectRegionId);

void upsertRegion(pqxx::transaction_base& coreTxn, const Region& region);

} // namespace maps::wiki::pedestrian
