#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <map>
#include <optional>

namespace maps::wiki::poi_conflicts {
using TZoom = size_t;

enum class Kind
{
    PoiVsPoi,
    PoiVsGeoproduct,
    GeoproductVsGeoproduct
};

enum class ConflictSeverity
{
    Critical,
    Error
};

DECLARE_ENUM_IO(ConflictSeverity);

class PoiConflicts
{
public:
    PoiConflicts();

    double maxConflictDistanceMercator() const
    { return maxDistanceMercator_; }

    std::optional<TZoom> conflictZoom(double distanceMercator, Kind kind = Kind::GeoproductVsGeoproduct) const;

private:
    bool verify() const;

    std::map<TZoom, double> zoomToConflictDistanceMercator_;
    double maxDistanceMercator_;
};

} //namespace maps::wiki::poi_conflicts
