#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_settings_config.h>
#include <maps/wikimap/mapspro/libs/poi_feed/include/helpers.h>

#include <maps/libs/json/include/value.h>
#include <maps/libs/common/include/exception.h>
#include <library/cpp/resource/resource.h>

using namespace std::literals;

namespace maps::wiki::poi_feed {
namespace {
namespace feed_seetings_json {
const auto FEED_SETTINGS_RESOURCE_KEY = "FEED_SETTINGS_RESOURCE"s;
const auto GEOMETRY_UPDATE = "geometryUpdate"s;
const auto MIN_DISTANCE = "minDistance"s;
const auto FEEDBACK_DISTANCE = "feedbackDistance"s;
const auto SPRAV_FEEDBACK_DISTANCE = "spravFeedbackDistance"s;
const auto MODERATE_ALL_CHANGES = "moderateAllChanges"s;
};
} // namespace

FeedSettingsConfig::FeedSettingsConfig()
{
    const auto protectedFtTypes = loadProtectedFtTypes();
    auto resourceJson = maps::json::Value::fromString(
        NResource::Find(feed_seetings_json::FEED_SETTINGS_RESOURCE_KEY));
    ASSERT(resourceJson.isObject());
    for (const auto& fieldName : resourceJson.fields()) {
        const auto& settingsJson = resourceJson[fieldName];
        ASSERT(settingsJson.isObject());
        const auto& geometryUpdate = settingsJson[feed_seetings_json::GEOMETRY_UPDATE];
        ASSERT(geometryUpdate.isObject());
        auto ftTypeId = boost::lexical_cast<FtTypeId>(fieldName);
        FeedSettings feedSettings;
        if (protectedFtTypes.count(ftTypeId) ||
            (settingsJson.hasField(feed_seetings_json::MODERATE_ALL_CHANGES) &&
             settingsJson[feed_seetings_json::MODERATE_ALL_CHANGES].as<bool>()))
        {
            feedSettings.moderateAllChanges = ModerateAllChanges::Yes;
        }
        if (geometryUpdate.hasField(feed_seetings_json::MIN_DISTANCE)) {
            feedSettings.minDistance =
                geometryUpdate[feed_seetings_json::MIN_DISTANCE].as<double>();
        }
        if (geometryUpdate.hasField(feed_seetings_json::FEEDBACK_DISTANCE)) {
            feedSettings.feedbackDistance =
                geometryUpdate[feed_seetings_json::FEEDBACK_DISTANCE].as<double>();
        }
        if (geometryUpdate.hasField(feed_seetings_json::SPRAV_FEEDBACK_DISTANCE)) {
            feedSettings.spravFeedbackDistance =
                geometryUpdate[feed_seetings_json::SPRAV_FEEDBACK_DISTANCE].as<double>();
        }
        feedSettings_.emplace(ftTypeId, feedSettings);
    }
}

const FeedSettings*
FeedSettingsConfig::feedSettings(FtTypeId ftTypeId) const
{
    auto it = feedSettings_.find(ftTypeId);
    return it == feedSettings_.end()
        ? NULL
        : &it->second;
}

std::set<FtTypeId>
FeedSettingsConfig::configuredFtTypes() const
{
    std::set<FtTypeId> ftTypeIds;
    for (const auto& [id, _] : feedSettings_) {
        ftTypeIds.insert(id);
    }
    return ftTypeIds;
}
} // maps::wiki::poi_feed
