#include <maps/wikimap/mapspro/libs/poi_feed/include/helpers.h>

#include <maps/libs/json/include/value.h>
#include <maps/libs/xml/include/xml.h>
#include <library/cpp/resource/resource.h>
#include <maps/libs/common/include/exception.h>
#include <boost/lexical_cast.hpp>

namespace maps::wiki::poi_feed {
namespace {

namespace landmark_json {
    const std::string LANDMARK_FT_TYPE_ID = "protected_ft_type_ids";
    const std::string LANDMARKS_RESOURCE_KEY = "LANDMARKS_RESOURCE";
} // landmark_json

const std::set<std::string> POI_POSITION_QUALITY_VERIFIED_VALUES {
    "user",
    "precise"
};

const std::string ALTAY_MERGED_FT_TYPE_IDS = "ALTAY_MERGED_FT_TYPE_IDS";

class AltayMergedFtTypeFtTypesHolder : public std::set<FtTypeId>
{
public:
    AltayMergedFtTypeFtTypesHolder()
    {
        auto resourceXml = maps::xml3::Doc::fromString(NResource::Find(ALTAY_MERGED_FT_TYPE_IDS));
        const auto nodes = resourceXml.nodes("//business-merged-ft-type-ids/ft-type-id");
        for (size_t i = 0; i < nodes.size(); ++i) {
            insert(nodes[i].value<FtTypeId>());
        }
    }
};

} // namespace

std::set<FtTypeId>
loadProtectedFtTypes()
{
    auto resourceJson = maps::json::Value::fromString(
        NResource::Find(landmark_json::LANDMARKS_RESOURCE_KEY));
    ASSERT(resourceJson.isObject() &&
        resourceJson.hasField(landmark_json::LANDMARK_FT_TYPE_ID) &&
        resourceJson[landmark_json::LANDMARK_FT_TYPE_ID].isArray());
    std::set<poi_feed::FtTypeId> ftTypeIds;
    for (const auto& value : resourceJson[landmark_json::LANDMARK_FT_TYPE_ID]) {
        ftTypeIds.insert(boost::lexical_cast<poi_feed::FtTypeId>(value.as<std::string>()));
    }
    return ftTypeIds;
}

bool isFullMergeImplemented(FtTypeId ftTypeId)
{
    static const AltayMergedFtTypeFtTypesHolder altayMergedFtTypeFtTypes;
    ASSERT(altayMergedFtTypeFtTypes.size());
    return altayMergedFtTypeFtTypes.count(ftTypeId);
}

bool isVerifiedPositionQuality(const std::string& positionQuality)
{
    return POI_POSITION_QUALITY_VERIFIED_VALUES.contains(positionQuality);
}

} // namespace maps::wiki::poi_feed
