#pragma once

#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_object_data.h>

#include <optional>
#include <unordered_map>

namespace maps::wiki::poi_feed {

enum class ModerateAllChanges
{
    Yes,
    No
};

constexpr double DEFAULT_MIN_MOVE_METERS = 1.0;

struct FeedSettings
{
    double minDistance = DEFAULT_MIN_MOVE_METERS;
    std::optional<double> feedbackDistance;
    std::optional<double> spravFeedbackDistance;
    ModerateAllChanges moderateAllChanges = ModerateAllChanges::No;
};

class FeedSettingsConfig
{
public:
    FeedSettingsConfig();

    const FeedSettings* feedSettings(FtTypeId ftTypeId) const;

    std::set<FtTypeId> configuredFtTypes() const;

private:
    std::unordered_map<FtTypeId, FeedSettings> feedSettings_;
};
} //maps::wiki::poi_feed
