#pragma once

#include <yandex/maps/wiki/pubsub/common.h>

#include <maps/libs/introspection/include/comparison.h>

#include <tuple>

namespace maps::wiki::pubsub {

struct Item
{
    int64_t txid = 0;
    CommitId key = 0;

    Item() = default;

    Item(const pqxx::row& row)
        : txid(row["txid"].as<int64_t>())
        , key(row["commit_id"].as<CommitId>())
    {
    }

    std::string toString() const
    {
        return std::to_string(txid) + ',' + std::to_string(key);
    }

    auto introspect() const
    {
        return std::tie(txid, key);
    }
};

using maps::introspection::operator==;
using maps::introspection::operator<;

} // namespace maps::wiki::pubsub
