from .cpplogger import *  # noqa
from .cpplogger import set_log_backend
from .cpplogger import reset_log_backend

# Import logging here so that our atexit handler is executed first.
import logging
import atexit

atexit.register(reset_log_backend)


class _TimeFixer(logging.Filter):
    def filter(self, record):
        if hasattr(record, 'ymlog_created'):
            record.created = record.ymlog_created
        return True

_logger = None


def init_logger(name=__name__):
    '''
    Create python logger with name @name and redirect messages from
    libyandex-maps-log to it.
    '''

    global _logger
    if _logger is None:
        _logger = logging.getLogger(name)
        _logger.addFilter(_TimeFixer())
        set_log_backend(name)
