#include "pyresultsviewer.h"

#include <yandex/maps/wiki/diffalert/message.h>

#include <yandex/maps/wiki/common/pyutils.hpp>

namespace bp = boost::python;

namespace maps {
namespace wiki {
namespace diffalert {
namespace python {
namespace {

StoredMessagesFilter extractFilter(
        bp::object geomWkb,
        bp::object majorPriority,
        bp::object categoryIds,
        bp::object description,
        bp::object regionPriority,
        bp::object postponed,
        bp::object excludeInspectedBy)
{
    StoredMessagesFilter filter;
    filter.geomWkb = common::toOptional<std::string>(geomWkb);
    filter.majorPriority = common::toOptional<uint32_t>(majorPriority);
    if (categoryIds != bp::object()) {
        filter.categoryIds = common::toVector<std::string>(categoryIds);
    }
    filter.description = common::toOptional<std::string>(description);
    filter.regionPriority = common::toOptional<uint32_t>(regionPriority);
    filter.postponed = common::toOptional<bool>(postponed);
    filter.excludeInspectedBy = common::toOptional<TUId>(excludeInspectedBy);

    return filter;
}

} // namespace

PyResultsViewer::PyResultsViewer(TaskId taskId, boost::python::object pool)
    : pgPoolPyObject_(pool)
    , txn_(
        bp::extract<pgpool3::Pool&>(pgPoolPyObject_)().masterReadOnlyTransaction())
    , viewer_(taskId, *txn_)
{ }

TaskId PyResultsViewer::taskId() const
{ return viewer_.taskId(); }

size_t PyResultsViewer::messageCount(
        bp::object geomWkb,
        bp::object majorPriority,
        bp::object categoryIds,
        bp::object description,
        bp::object regionPriority,
        bp::object postponed,
        bp::object excludeInspectedBy)
{
    auto filter = extractFilter(
        geomWkb,
        majorPriority,
        categoryIds,
        description,
        regionPriority,
        postponed,
        excludeInspectedBy);
    return viewer_.messageCount(filter);
}

bp::list PyResultsViewer::statistics(
        bp::object geomWkb,
        bp::object majorPriority,
        bp::object regionPriority,
        bp::object postponed,
        bp::object excludeInspectedBy)
{
    auto filter = extractFilter(
        geomWkb,
        majorPriority,
        bp::object(),
        bp::object(),
        regionPriority,
        postponed,
        excludeInspectedBy);
    bp::list stats;
    for (const auto& pair : viewer_.statistics(filter)) {
        stats.append(pair);
    }
    return stats;
}

bp::list PyResultsViewer::messages(
        SortKind sortKind,
        size_t offset,
        size_t limit,
        bp::object geomWkb,
        bp::object majorPriority,
        bp::object categoryIds,
        bp::object description,
        bp::object regionPriority,
        bp::object postponed,
        bp::object excludeInspectedBy)
{
    auto filter = extractFilter(
        geomWkb,
        majorPriority,
        categoryIds,
        description,
        regionPriority,
        postponed,
        excludeInspectedBy);
    return common::toPyList(viewer_.messages(filter, sortKind, offset, limit));
}

boost::python::list PyResultsViewer::messageIds(
    bp::object geomWkb,
    bp::object majorPriority,
    bp::object categoryIds,
    bp::object description,
    bp::object regionPriority,
    bp::object postponed,
    bp::object excludeInspectedBy)
{
    auto filter = extractFilter(
        geomWkb,
        majorPriority,
        categoryIds,
        description,
        regionPriority,
        postponed,
        excludeInspectedBy);
    return common::toPyList(viewer_.messageIds(filter));
}

boost::python::object PyResultsViewer::message(StoredMessageId messageId)
{
    return common::toPyObject(viewer_.message(messageId));
}

} // namespace python
} // namespace diffalert
} // namespace wiki
} // namespace maps
