#pragma once

#include <yandex/maps/wiki/diffalert/storage/results_viewer.h>
#include <yandex/maps/wiki/diffalert/storage/stored_message.h>

#include <maps/libs/pgpool/include/pgpool3.h>

#include <boost/python/list.hpp>
#include <boost/python/object.hpp>

#include <cstdint>

namespace maps {
namespace wiki {
namespace diffalert {
namespace python {

class PyResultsViewer
{
public:
    PyResultsViewer(TaskId taskId, boost::python::object pool);

    TaskId taskId() const;

    size_t messageCount(
        boost::python::object geomWkb,
        boost::python::object majorPriority,
        boost::python::object categories,
        boost::python::object description,
        boost::python::object regionPriority,
        boost::python::object postponed,
        boost::python::object excludeInspectedBy);

    boost::python::list statistics(
        boost::python::object geomWkb,
        boost::python::object majorPriority,
        boost::python::object regionPriority,
        boost::python::object postponed,
        boost::python::object excludeInspectedBy);

    boost::python::list messages(
        SortKind sortKind,
        size_t offset,
        size_t limit,
        boost::python::object geomWkb,
        boost::python::object majorPriority,
        boost::python::object categories,
        boost::python::object description,
        boost::python::object regionPriority,
        boost::python::object postponed,
        boost::python::object excludeInspectedBy);

    boost::python::list messageIds(
        boost::python::object geomWkb,
        boost::python::object majorPriority,
        boost::python::object categories,
        boost::python::object description,
        boost::python::object regionPriority,
        boost::python::object postponed,
        boost::python::object excludeInspectedBy);

    boost::python::object message(StoredMessageId messageId);

private:
    boost::python::object pgPoolPyObject_;
    pgpool3::TransactionHandle txn_;
    ResultsViewer viewer_;
};

} // namespace python
} // namespace diffalert
} // namespace wiki
} // namespace maps
