#!/usr/bin/python
import psycopg2

from yandex.maps.opster3 import command, dispatch

from yandex.maps.wiki.converters import postgre2dump
from yandex.maps.wiki.utils import archive, schema_tables

@command(usage="--connstr=connection_string --schema=schema_name --outdir=output_dir")
def pg2dump(connstr = ('', '', 'connections string'),
            schema = ('', '', 'schema name'),
            outdir = ('', '', 'output directory')):
    conn = psycopg2.connect(connstr)
    tables = schema_tables(schema, conn.cursor())
    postgre2dump(conn, schema, tables, outdir)
    conn.close()
    archive(outdir)


if __name__ == '__main__':
    dispatch()
