# encoding: utf8
"""
    Tools for colored terminal output.
"""

import functools
import sys

import six
if six.PY3:
    unicode = str


def color_seq(color, bold):
    return '\033[%sm' % (('1;' if bold else '') + str(COLORS[color]))

COLORS = {
    'black': 30,
    'red': 31,
    'green': 32,
    'yellow': 33,
    'blue': 34,
    'magenta': 35,
    'cyan': 36,
    'white': 37,
}

RESET_SEQ = '\033[0m'


def colored_string(color, string, bold=True):
    if isinstance(string, unicode):
        string = string.encode(sys.stdout.encoding)
    return color_seq(color, bold) + string + RESET_SEQ

for _color in COLORS.keys():
    globals()[_color] = functools.partial(colored_string, _color)
