# -*- coding: utf-8 -*-

import os
import os.path
import sys
import logging
import logging.config

_initialized = False


def setup_logging(config_filename=None, simple=False):
    """ Эта функция инициализирует модуль logging.
        Если задан параметр config_filename, то он будет передан
        в функцию logging.config.fileConfig. В противном случае,
        функция попытается получить имя файла из переменной
        окружения LOGGING_CONFIG, а если и оно не найдено, то
        будет использовано значение "по-умолчанию" logging.cfg.

        Если задан параметр simple = True, то вместо конфигурационного
        файла будут использованы простейшие настройки: вывод лога в
        STDERR и уровень логирования logging.ERROR.
    """
    global _initialized

    if not _initialized:
        if simple:
            logging.basicConfig(stream=sys.stderr, level=logging.ERROR)
        else:
            config_filename = config_filename or \
                os.getenv('LOGGING_CONFIG', 'logger.cfg')
            if os.path.exists(config_filename):
                logging.config.fileConfig(config_filename)
        _initialized = True
