PRECEDENCE = ['SUCCESS',
              'FAILURE',
              None,
              'FROZEN',
              'REVOKED',
              'STARTED',
              'PENDING']

#: Hash lookup of PRECEDENCE to index
PRECEDENCE_LOOKUP = dict(zip(PRECEDENCE, range(0, len(PRECEDENCE))))
NONE_PRECEDENCE = PRECEDENCE_LOOKUP[None]


def precedence(state):
    """Get the precedence index for state.

    Lower index means higher precedence.

    """
    return PRECEDENCE_LOOKUP.get(state, NONE_PRECEDENCE)

PENDING = 'PENDING'
STARTED = 'STARTED'
SUCCESS = 'SUCCESS'
FAILURE = 'FAILURE'
REVOKED = 'REVOKED'
FROZEN = 'FROZEN'
