from .revision import *  # noqa
from .revision import Attributes
from .revision import RevisionsGateway

from yandex.maps.wiki.pgpool3 import get_pgpool

TRUNK_BRANCH_ID = 0

BRANCH_TYPE_TRUNK = "trunk"
BRANCH_TYPE_APPROVED = "approved"
BRANCH_TYPE_STABLE = "stable"
BRANCH_TYPE_ARCHIVE = "archive"
BRANCH_TYPE_DELETED = "deleted"

BRANCH_STATE_LOCKED = ""
BRANCH_STATE_NORMAL = "normal"
BRANCH_STATE_PROGRESS = "progress"
BRANCH_STATE_UNAVAILABLE = "unavailable"


class ObjectData(object):

    def __init__(self,
                 id,
                 attrs=None,
                 desc=None,
                 geom=None,
                 relation_data=None,
                 deleted=False):
        self.id = id
        if isinstance(attrs, dict):
            self.attrs = Attributes(attrs)
        else:
            self.attrs = attrs
        self.desc = desc
        self.geom = geom
        self.relation_data = relation_data
        self.deleted = deleted


def create_gateway(db_id, branch_id):
    return RevisionsGateway(get_pgpool(db_id), branch_id)
