from ..revision_filters import *  # noqa
from ..revision_filters import TrueFilter
from ..revision_filters import FalseFilter
from ..revision_filters import create_negative_filter
from ..revision_filters import create_binary_filter
from ..revision_filters import BinaryOperation

TRUE = TrueFilter()
FALSE = FalseFilter()


def not_(expr):
    return create_negative_filter(expr)


def and_(first, *rest):
    if not rest:
        return first
    return create_binary_filter(BinaryOperation.AND, first, and_(*rest))


def or_(first, *rest):
    if not rest:
        return first
    return create_binary_filter(BinaryOperation.OR, first, or_(*rest))
