#include <yandex/maps/wiki/social/feedback/converter_checks.h>
#include <yandex/maps/wiki/common/pyutils.hpp>

#include <boost/python.hpp>
#include <boost/lexical_cast.hpp>

namespace bp = boost::python;

namespace maps::wiki::social::python {

namespace {

bp::list allFeedbackTypes()
{
    std::vector<std::string> vec;
    for (const auto& type: feedback::allTypes()) {
        vec.push_back(boost::lexical_cast<std::string>(type));
    }
    return common::toPyList(vec);
}

bp::list allFeedbackWorkflows()
{
    std::vector<std::string> vec;
    for (const auto& workflow: feedback::allWorkflows()) {
        vec.push_back(boost::lexical_cast<std::string>(workflow));
    }
    return common::toPyList(vec);
}

bp::list validationFeedbackConverterChecksList()
{
    std::vector<std::string> vec;
    for (const auto& check: feedback::validationFeedbackConverterChecks()) {
        vec.push_back(boost::lexical_cast<std::string>(check));
    }
    return common::toPyList(vec);
}

bp::list validationFeedbackConverterDescriptionsList()
{
    std::vector<std::string> vec;
    for (const auto& check: feedback::validationFeedbackConverterDescriptions()) {
        vec.push_back(boost::lexical_cast<std::string>(check));
    }
    return common::toPyList(vec);
}

} // namespace

BOOST_PYTHON_MODULE(feedback)
{
    using namespace bp;

    def("all_types", &allFeedbackTypes);
    def("all_workflows", &allFeedbackWorkflows);
    def("validation_feedback_converter_checks",
        &validationFeedbackConverterChecksList);
    def("validation_feedback_converter_descriptions",
        &validationFeedbackConverterDescriptionsList);
}

} // namespace maps::wiki::social::python
