#pragma once

#include <yandex/maps/wiki/validator/storage/results_gateway.h>
#include <yandex/maps/wiki/revision/common.h>

#include <maps/libs/pgpool/include/pgpool3.h>

#include <memory>
#include <string>

#include <boost/noncopyable.hpp>
#include <boost/python/dict.hpp>
#include <boost/python/list.hpp>
#include <boost/python/object.hpp>

namespace bp = boost::python;

namespace maps {
namespace wiki {
namespace validator {
namespace python {

void storeResult(
    ResultPtr result,
    pgpool3::Pool& pgPool,
    TTaskId taskId);

class PyResultsGateway : boost::noncopyable
{
public:
    PyResultsGateway(
        bp::object pgPoolPyObject,
        TTaskId taskId);

    TTaskId taskId() const;

    size_t messageCount(
            bp::object severity,
            bp::object checkId,
            bp::object description,
            bp::object regionType) const;

    bp::list statistics(
            bp::object severity,
            bp::object regionType) const;

    bp::list messages(
            pgpool3::Pool& revPgPool,
            const std::string& revToken,
            revision::DBID branchId,
            size_t offset, size_t limit,
            revision::UserID uid,
            bp::object severity,
            bp::object checkId,
            bp::object description,
            bp::object regionType) const;

    bp::list checkIdsWithFatalErrors() const;

    bp::object messageSetViewed(
        pgpool3::Pool& revPgPool,
        revision::DBID branchId,
        revision::UserID uid,
        const std::string& messageId) const;

private:
    bp::object pgPoolPyObject_;
    pgpool3::TransactionHandle transaction_;
    storage::ResultsGateway gateway_;
};

} // namespace python
} // namespace validator
} // namespace wiki
} // namespace maps
