#pragma once

#include <yandex/maps/wiki/validator/validator_config.h>
#include <yandex/maps/wiki/validator/validator.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include <boost/python.hpp>

#include <memory>

namespace bp = boost::python;

namespace maps {
namespace wiki {
namespace validator {
namespace python {

class PyValidator : boost::noncopyable
{
public:
    explicit PyValidator(const ValidatorConfig& validatorConfig);

    ResultPtr run(
        const bp::object& checks,
        pgpool3::Pool& pgPool,
        revision::DBID branchId,
        revision::DBID commitId,
        const bp::object& aoiWkb,
        const bp::object& aoiCoverageDir,
        const bp::object& aoiBuffer);

    void enableCardinalityCheck();

    void initModules();

    bp::list modules() const;

private:
    Validator validator_;
};

} // namespace python
} // namespace validator
} // namespace wiki
} // namespace maps
