#include <maps/wikimap/mapspro/libs/query_builder/include/compound_query.h>

namespace maps::wiki::query_builder {

std::string CompoundQuery::asString(const pqxx::transaction_base& txn) const
{
    std::string result;
    for (const auto& query : queries_) {
        auto str = query->asString(txn);
        if (!str.empty()) {
            result += (result.empty() ? "" : ";") + str;
        }
    }
    return result;
}

pqxx::result CompoundQuery::exec(pqxx::transaction_base& txn) const
{
    auto query = asString(txn);
    return txn.exec(query);
}

void CompoundQuery::execNotEmpty(pqxx::transaction_base& txn) const
{
    auto query = asString(txn);
    if (!query.empty()) {
        txn.exec(query);
    }
}

} // namespace maps::wiki::query_builder
