#include <maps/wikimap/mapspro/libs/query_builder/include/count_query.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::query_builder {

CountQuery::CountQuery(
    std::string table,
    WhereConditions whereConditions,
    std::string column)
    : table_(std::move(table))
    , whereConditions_(std::move(whereConditions))
    , column_(std::move(column))
{}

std::string CountQuery::asString(const pqxx::transaction_base& txn) const
{
    std::ostringstream query;
    query << "SELECT COUNT (" << column_ << ") FROM " << table_;
    if (!whereConditions_.empty()) {
        query << ' ' << whereConditions_.asString(txn);
    }
    return query.str();
}

auto CountQuery::introspect() const
{
    return std::tie(table_, whereConditions_, column_);
}

uint64_t CountQuery::exec(pqxx::transaction_base& txn) const
{
    const auto query = asString(txn);
    DEBUG() << "Perform query: " << query;

    auto rows = txn.exec(query);
    return rows.front()["count"].as<uint64_t>();
}

} // namespace maps::wiki::query_builder
