#include <maps/wikimap/mapspro/libs/query_builder/include/delete_query.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::query_builder {

DeleteQuery::DeleteQuery(
    std::string table,
    WhereConditions whereConditions)
    : table_(std::move(table))
    , whereConditions_(std::move(whereConditions))
{}

std::string DeleteQuery::asString(const pqxx::transaction_base& txn) const
{
    REQUIRE(
        !whereConditions_.empty(),
        "Cannot build delete query with empty where conditions for table "
            << table_);
    std::ostringstream query;

    query << "DELETE FROM " << table_
        << ' ' << whereConditions_.asString(txn);
    return query.str();
}

auto DeleteQuery::introspect() const
{
    return std::tie(table_, whereConditions_);
}

pqxx::result DeleteQuery::exec(pqxx::transaction_base& txn) const
{
    const auto query = asString(txn);
    DEBUG() << "Perform query: " << query;
    return txn.exec(query);
}

} // namespace maps::wiki::query_builder
