#include <maps/wikimap/mapspro/libs/query_builder/include/modify_query.h>

#include <maps/wikimap/mapspro/libs/query_builder/include/insert_query.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/update_query.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::query_builder {

namespace internal {

template <class T>
ModifyQuery<T>::ModifyQuery(std::string table)
    : table_(std::move(table))
{}

template <class T>
T& ModifyQuery<T>::appendRawQuoted(std::string key, std::string value)
{
    data_.appendRawQuoted(std::move(key), std::move(value));
    return static_cast<T&>(*this);
}

template <class T>
pqxx::result ModifyQuery<T>::exec(pqxx::transaction_base& txn) const
{
    const auto query = asString(txn);
    DEBUG() << "Perform query: " << query;
    return txn.exec(query);
}

template <class T>
T& ModifyQuery<T>::setReturning(std::vector<std::string> columns)
{
    data_.setReturning(std::move(columns));
    return static_cast<T&>(*this);
}

template class ModifyQuery<InsertQuery>;
template class ModifyQuery<UpdateQuery>;

} // namespace internal

} // namespace maps::wiki::query_builder
