#pragma once

#include <maps/wikimap/mapspro/libs/query_builder/include/query.h>
#include <list>
#include <memory>
#include <optional>

namespace maps::wiki::query_builder {

// Supposed usage:
//
// query_builder::CompoundQuery()
//    .append(makeInsertQuery(...))
//    .append(makeUpdateQuery(...))
//    .append(makeCountQuery(...))
//    ...
//    .asString(txn)/exec(txn);

class CompoundQuery : public Query {
public:
    CompoundQuery() = default;

    std::string asString(const pqxx::transaction_base& txn) const override;

    pqxx::result exec(pqxx::transaction_base& txn) const;
    void execNotEmpty(pqxx::transaction_base& txn) const;

    bool empty() const { return queries_.empty(); }
    size_t size() const { return queries_.size(); }

    template <typename TQuery>
    CompoundQuery& append(TQuery query)
    {
        queries_.emplace_back(std::make_shared<TQuery>(std::move(query)));
        return *this;
    }

    CompoundQuery& append(CompoundQuery query)
    {
        if (!query.empty()) {
            queries_.emplace_back(std::make_shared<CompoundQuery>(std::move(query)));
        }
        return *this;
    }

    template <typename TQuery>
    CompoundQuery& append(std::optional<TQuery> query)
    {
        if (query) {
            append(std::move(*query));
        }
        return *this;
    }

private:
    std::list<std::shared_ptr<Query>> queries_;
};

} // namespace maps::wiki::query_builder
