#pragma once

#include <maps/wikimap/mapspro/libs/query_builder/include/query.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/where_conditions.h>

namespace maps::wiki::query_builder {

// Supposed usage:
//
// query_builder::CountQuery(
//    table_name,
//    query_builder::WhereConditions()
//         .append(created_at, date, Relation::Greater)
//         .append(key, value),
//    column_name)
//    .asString(txn)/exec(txn);

class CountQuery : public Query {
public:
    CountQuery(
        std::string table,
        WhereConditions whereConditions = {},
        std::string column = "*");

    std::string asString(const pqxx::transaction_base& txn) const override;
    uint64_t exec(pqxx::transaction_base& txn) const;

    auto introspect() const;

private:
    std::string table_;
    WhereConditions whereConditions_;
    std::string column_;
};

} // namespace maps::wiki::query_builder
