#pragma once

#include <maps/wikimap/mapspro/libs/query_builder/include/query.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/where_conditions.h>

#include <vector>

namespace maps::wiki::query_builder {

// Supposed usage:
//
// query_builder::DeleteQuery(
//    table_name,
//    query_builder::WhereConditions()
//         .append(created_at, date, Relation::Greater)
//         .append(key2, value2))
//    .asString(txn)/exec(txn);

class DeleteQuery : public Query {
public:
    DeleteQuery(std::string table, WhereConditions whereConditions);

    std::string asString(const pqxx::transaction_base& txn) const override;
    pqxx::result exec(pqxx::transaction_base& txn) const;

    auto introspect() const;

private:
    std::string table_;
    WhereConditions whereConditions_;
};

} // namespace maps::wiki::query_builder
