#pragma once

#include <maps/wikimap/mapspro/libs/query_builder/include/modify_query.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/on_conflict.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/where_conditions.h>

#include <pqxx/pqxx>

namespace maps::wiki::query_builder {

// Supposed usage:
//
// query_builder::InsertQuery(table_name)
//     .append(id, id)
//     .append(key1, value1)
//     .append(key2, value2)
//     ...
//     .asString(txn)/exec(txn);

namespace internal {

std::string buildInsertQuery(
    const pqxx::transaction_base& txn,
    const std::string& table,
    const std::map<std::string, QuotedValue>& keyValues,
    const std::optional<OnConflict>& onConflict,
    const std::vector<std::string>& returning = {});

} // namespace internal

class InsertQuery : public internal::ModifyQuery<InsertQuery> {
public:
    explicit InsertQuery(std::string table);

    InsertQuery& updateOnConflict(OnConflict onConflict);
    std::string asString(const pqxx::transaction_base& txn) const override;

private:
    std::optional<OnConflict> onConflict_;
};

} // namespace maps::wiki::query_builder
