#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <sstream>
#include <string>
#include <vector>

namespace maps::wiki::query_builder {

enum class JoinType {
    Inner,
    Left,
    Right,
    Full
};
DECLARE_ENUM_IO(JoinType);

struct JoinCondition {
    std::string column;
    std::string otherTable;
    std::string otherColumn;

    std::string asString(const std::string& table) const;
};

struct JoinStatement {
    JoinType joinType;
    const std::string table;
    std::vector<JoinCondition> conditions;

    std::string asString() const;
};

class JoinSequence {
public:
    JoinSequence(std::string table);

    JoinSequence& join(JoinStatement);

    std::string asString() const;

private:
    std::string table;
    std::vector<JoinStatement> joins;
};

} // namespace maps::wiki::query_builder
