#pragma once

#include <maps/wikimap/mapspro/libs/query_builder/include/common.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/query.h>

#include <map>
#include <pqxx/pqxx>

namespace maps::wiki::query_builder {

namespace internal {

template <class T>
class ModifyQuery : public Query {
public:
    explicit ModifyQuery(std::string table);
    ModifyQuery(ModifyQuery&&) = default;
    ModifyQuery& operator=(ModifyQuery&&) = default;
    virtual ~ModifyQuery() = default;

    template <typename ValueType>
    T& append(std::string key, ValueType value)
    {
        data_.append(std::move(key), static_cast<std::string>(std::move(value)));
        return static_cast<T&>(*this);
    }
    T& append(std::string key, std::string value)
    {
        data_.append(std::move(key), std::move(value));
        return static_cast<T&>(*this);
    }
    template <typename ValueType>
    T& append(std::string key, std::optional<ValueType> value)
    {
        if (value) {
            append(key, std::move(*value));
        }
        return static_cast<T&>(*this);
    }
    template <typename ValueType>
    T& appendQuoted(std::string key, ValueType value)
    {
        data_.appendQuoted(std::move(key), static_cast<std::string>(std::move(value)));
        return static_cast<T&>(*this);
    }
    T& appendQuoted(std::string key, std::string value)
    {
        data_.appendQuoted(std::move(key), std::move(value));
        return static_cast<T&>(*this);
    }
    template <typename ValueType>
    T& appendQuoted(std::string key, std::optional<ValueType> value)
    {
        if (value) {
            appendQuoted(key, std::move(*value));
        }
        return static_cast<T&>(*this);
    }
    T& appendRawQuoted(std::string key, std::string value);

    T& setReturning(std::vector<std::string> columns);

    bool empty() const { return data_.empty(); }
    pqxx::result exec(pqxx::transaction_base& txn) const;

    auto introspect() const { return std::tie(table_, data_); }

protected:
    std::string table_;
    ModifyData data_;
};

} // namespace internal

} // namespace maps::wiki::query_builder
