#pragma once

#include <maps/wikimap/mapspro/libs/query_builder/include/common.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/update_query.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/where_conditions.h>

#include <pqxx/pqxx>

namespace maps::wiki::query_builder {

class UpdateOnConflict : public UpdateQuery {
public:
    explicit UpdateOnConflict(WhereConditions whereConditions = {});
    UpdateOnConflict(UpdateOnConflict&&) = default;
    UpdateOnConflict& operator=(UpdateOnConflict&&) = default;
};

class OnConflict {
public:
    OnConflict(
        std::optional<std::string> constraint,
        std::vector<std::string> columns,
        UpdateOnConflict,
        WhereConditions whereConditions);

    OnConflict() = default;
    OnConflict(OnConflict&&) = default;
    OnConflict& operator=(OnConflict&&) = default;

    static OnConflict fromColumns(
        std::vector<std::string> columns,
        UpdateOnConflict,
        WhereConditions = {}
    );
    static OnConflict fromConstraint(
        std::string constraint,
        UpdateOnConflict,
        WhereConditions = {}
    );

    std::string asString(const pqxx::transaction_base& txn) const;

private:
    std::optional<std::string> constraint_;
    std::vector<std::string> columns_;
    UpdateOnConflict updateOnConflict_;
    WhereConditions whereConditions_;
};

} // namespace maps::wiki::query_builder

