#pragma once

#include <maps/wikimap/mapspro/libs/query_builder/include/modify_query.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/where_conditions.h>

namespace maps::wiki::query_builder {

// Supposed usage:
//
// query_builder::UpdateQuery(
//     table_name,
//     query_builder::WhereConditions()
//         .append(created_at, date, Relation::Less)
//         .append(key, value))
//     .append(key, new_value)
//     .asString(txn)/exec(txn);

namespace internal {

std::string buildUpdateQuery(
    const pqxx::transaction_base& txn,
    const std::string& table,
    const std::map<std::string, QuotedValue>& keyValues,
    const std::map<std::string, JsonbEntry>& jsonbEntries,
    const WhereConditions& whereCondition,
    const std::vector<std::string>& returning = {});

} // namespace internal

class UpdateQuery : public internal::ModifyQuery<UpdateQuery> {
public:
    explicit UpdateQuery(std::string table, WhereConditions whereConditions = {});
    UpdateQuery(UpdateQuery&&) = default;
    UpdateQuery& operator=(UpdateQuery&&) = default;

    std::string asString(const pqxx::transaction_base& txn) const override;

private:
    WhereConditions whereConditions_;
};

} // namespace maps::wiki::query_builder
