#include "branch_data.h"
#include "sql_strings.h"
#include "helpers.h"

#include <maps/libs/common/include/exception.h>

#include <boost/lexical_cast.hpp>

namespace maps::wiki::revision {

using namespace helpers;

BranchData::BranchData(const pqxx::row& row)
    : id(row[sql::col::ID].as<DBID>())
    , type(boost::lexical_cast<BranchType>(row[sql::col::TYPE].as<std::string>()))
    , state(boost::lexical_cast<BranchState>(row[sql::col::STATE].as<std::string>()))
    , createdBy(row[sql::col::CREATED_BY].as<UserID>())
    , finishedBy(row[sql::col::FINISHED_BY].as<UserID>())
    , createdAt(row[sql::col::CREATED_AT].as<std::string>())
    , finishedAt(row[sql::col::FINISHED_AT].c_str())
    , attributes(stringToAttributes(row[sql::col::ATTRIBUTES].c_str()))
{
    if (type == BranchType::Trunk) {
        ASSERT(id == TRUNK_BRANCH_ID && !createdBy && !finishedBy);
    } else {
        ASSERT(id != TRUNK_BRANCH_ID && createdBy);
        ASSERT(finishedBy || type == BranchType::Approved || type == BranchType::Stable);
        ASSERT(state == BranchState::Unavailable || type != BranchType::Deleted);
    }
}

} // namespace maps::wiki::revision
